package gov.va.genisis2.service.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.genisis2.dao.IAttachmentDAO;
import gov.va.genisis2.exceptions.GenisisServiceException;
import gov.va.genisis2.model.Attachment;
import gov.va.genisis2.service.IAttachmentService;

@Service
public class AttachmentService implements IAttachmentService {

	/** The LOGGER. */
	private static final Logger LOGGER = LoggerFactory.getLogger(AttachmentService.class);

	@Autowired
	private IAttachmentDAO attachmentDao;

	/**
	 * This method is used to submitOrModify.
	 * 
	 * @param attachment
	 *            The attachment.
	 * @return int This returns list of attachment id .
	 * 
	 */
	@Override
	public int submitOrModify(Attachment attachment) throws GenisisServiceException {
		try {
			return attachmentDao.submitOrModify(attachment);
		} catch (Exception ex) {
			LOGGER.error("Exception occurred on submitOrModify", ex);
			throw new GenisisServiceException(ex.getMessage(), ex);
		}
	}

}
